import 'package:course_app/utils/battle.dart';

// Provides tools for encoding and decoding JSON data
import 'dart:convert'; 
// Allows access to asset files
// The word "show" is used for convenience and it means
// we are only interested in that part of the package
// This is done to minimize naming conflicts
// The word "hide" can also be used which means
// {All Package} - {Hidden Classes}
import 'package:flutter/services.dart' show rootBundle; 

// Define a function to load battle data from a JSON file in the assets folder
Future<List<Battle>> loadBattlesFromFile() async 
{
  // Load the JSON file as a string from the assets folder.
  // The 'rootBundle' provides a way to access files bundled with the app.
  // 'loadString' reads the file and returns its content as a String.
  final String jsonString = await rootBundle.loadString('lib/assets/data/battles.json');

  // Decode the JSON string into a list of dynamic objects (maps).
  // The 'json.decode' function converts the JSON string into a list of maps
  // or any other structure as described in the JSON data.
  final List<dynamic> jsonData = json.decode(jsonString);

  // Convert the decoded JSON list into a list of Battle objects.
  // Each JSON item (map) is passed to the 'fromJson' constructor of the Battle class
  // to create a new Battle instance. 'toList()' converts the mapped iterable to a List.
  return jsonData.map((jsonItem) => Battle.fromJson(jsonItem)).toList();
}