import 'package:flutter/material.dart';
import 'package:course_app/utils/battle.dart';
// Add this file so that we can use the function
// loadBattlesFromFile() that loads data.
import 'package:course_app/utils/battle_loader.dart';

class BattleView extends StatelessWidget {
  @override
  Widget build(BuildContext context) {
    return Expanded(
      child: Padding(
        padding: const EdgeInsets.symmetric(vertical: 8.0),
        // We wrap the ListView.builder inside the FutureBuilder        
        child: FutureBuilder<List<Battle>>(
          // Specify the asynchronous operation to load the list of Battle objects
          // This will call the loadBattlesFromFile() function which reads data from the JSON file
          future: loadBattlesFromFile(),          
          builder: (context, snapshot) {
            // Check if the Future is still in a loading state
            // When waiting, show a loading indicator to let the user know data is being fetched
            if (snapshot.connectionState == ConnectionState.waiting) {
              // Show loading indicator while data is loading
              return Center(child: CircularProgressIndicator());
            // Check if there was an error while loading data from the Future
            // If an error occurs, display the error message to the user  
            } else if (snapshot.hasError) {
              // Display an error message if data loading fails
              return Center(child: Text('Error: ${snapshot.error}'));
            // Check if the data is successfully loaded and available in snapshot  
            } else if (snapshot.hasData) {
              // Retrieve the list of battles from snapshot.data, using an empty list if data is null
              final battles = snapshot.data ?? [];
              // The rest is as was
              return ListView.builder(
                itemCount: battles.length,
                itemBuilder: (context, index) {
                  final battle = battles[index];
                  return InkWell(
                    onTap: () {                      
                      Navigator.pushNamed(context, '/battle', arguments: {
                        'battle': battle
                      });
                    },
                    child: Container(
                      margin: EdgeInsets.symmetric(vertical: 5, horizontal: 10),
                      padding: EdgeInsets.all(10),
                      decoration: BoxDecoration(
                        color: Colors.grey[200],
                        border: Border.all(color: Colors.grey),
                        borderRadius: BorderRadius.circular(8),
                      ),
                      child: Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        children: [
                          Text(
                            battle.name!,
                            style: TextStyle(fontWeight: FontWeight.bold, fontSize: 16),
                          ),
                          SizedBox(height: 5),
                          Text(
                            battle.date!,
                            style: TextStyle(fontSize: 14, fontStyle: FontStyle.italic),
                          ),
                        ],
                      ),
                    ),
                  );
                },
              );
            } else {              
              return Center(child: Text('No battles found.'));
            }
          },
        ),
      ),
    );
  }
}
