class Battle {
  final int? id;
  final String name;
  final String date;
  final String summary;

  Battle({this.id, required this.name, required this.date, required this.summary});

  // Named constructor to create a Battle object from a Map
  Battle.fromMap(Map<String, dynamic> map)
      : id = map['id'],
        name = map['name'],
        date = map['date'],
        summary = map['summary'];

  // Convert a Battle object to a Map
  Map<String, dynamic> toMap() {
    return {
      'id': id,
      'name': name,
      'date': date,
      'summary': summary,
    };
  }
}
