// battle_screen.dart
import 'package:course_app/utils/battle.dart';
import 'package:course_app/utils/database_helper.dart';
import 'package:flutter/material.dart';

class BattleScreen extends StatefulWidget {
  @override
  _BattleScreenState createState() => _BattleScreenState();
}

class _BattleScreenState extends State<BattleScreen> {
  late TextEditingController _nameController;
  late TextEditingController _dateController;
  late TextEditingController _summaryController;
  late Battle battle;
  bool _isInitialized = false;

  @override
  void dispose() {
    _nameController.dispose();
    _dateController.dispose();
    _summaryController.dispose();
    super.dispose();
  }

  Future<void> _initializeControllers() async {
    final args =
        ModalRoute.of(context)!.settings.arguments as Map<String, dynamic>?;
    battle = args?['battle'] ?? Battle(id: 0, name: '', date: '', summary: '');

    _nameController = TextEditingController(text: battle.name);
    _dateController = TextEditingController(text: battle.date);
    _summaryController = TextEditingController(text: battle.summary);
    _isInitialized = true;
  }

  Future<void> _saveBattle() async {
    final dbHelper = DatabaseHelper.instance;
    battle = Battle(
      id: battle.id,
      name: _nameController.text,
      date: _dateController.text,
      summary: _summaryController.text,
    );

    await dbHelper.updateBattle(battle);
    ScaffoldMessenger.of(context)
        .showSnackBar(SnackBar(content: Text('Battle updated!')));

    // Pop the screen and notify the Home widget to rebuild
    Navigator.pop(
        context, true); // Pass 'true' to indicate that the battle was updated
  }

  @override
  Widget build(BuildContext context) {
    return FutureBuilder(
      future: _initializeControllers(),
      builder: (context, snapshot) {
        if (snapshot.connectionState == ConnectionState.waiting) {
          return Scaffold(
            body: Center(child: CircularProgressIndicator()),
          );
        }

        return Scaffold(
          appBar: AppBar(
            title: Text('Edit Battle'),
            backgroundColor: Colors.red,
            centerTitle: true,
          ),
          body: Padding(
            padding: const EdgeInsets.all(8.0),
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                TextField(
                  controller: _nameController,
                  decoration: InputDecoration(labelText: 'Battle Name'),
                  style: TextStyle(fontSize: 24, fontWeight: FontWeight.bold),
                ),
                TextField(
                  controller: _dateController,
                  decoration: InputDecoration(labelText: 'Date'),
                  style: TextStyle(fontSize: 20, fontStyle: FontStyle.italic),
                ),
                SizedBox(height: 10),
                Text('Summary:',
                    style:
                        TextStyle(fontSize: 18, fontWeight: FontWeight.bold)),
                Expanded(
                  child: SingleChildScrollView(
                    child: Column(
                      children: [
                        TextField(
                          controller: _summaryController,
                          decoration: InputDecoration(
                            //border: OutlineInputBorder(),
                            hintText: 'Enter summary here',
                          ),
                          style: TextStyle(fontSize: 18),
                          maxLines:
                              20, // Adjust based on desired default height
                        ),
                      ],
                    ),
                  ),
                ),
                SizedBox(height: 20),
                Center(
                  child: ElevatedButton(
                    onPressed: _saveBattle,
                    child: Text('Save Changes'),
                  ),
                ),
              ],
            ),
          ),
        );
      },
    );
  }
}
