import 'package:flutter/material.dart';
import 'package:course_app/utils/battle.dart';

class BattleView extends StatelessWidget {
  final List<Battle> battles;

  BattleView(this.battles);  

  @override
  Widget build(BuildContext context) {
    return Expanded(
      child: Padding(
        padding: const EdgeInsets.symmetric(vertical: 8.0),
        child: ListView.builder(
          itemCount: battles.length,
          itemBuilder: (context, index) {
            final battle = battles[index];            
            return InkWell(
              onTap: () {                
                // Navigate the page situated at '/battle'
                // We add a new parameter: arguments which expects a map
                // We are free to name the arguments the way we want
                // This will send a battle object battles[index]
                // with the key 'battle'
                // We could have also used two parameters 'name' and
                // 'date' and sent them to the other end of the route
                Navigator.pushNamed(context, '/battle', arguments: {
                  'battle': battles[index]
                });
              },              
              child: Container(
                margin: EdgeInsets.symmetric(vertical: 5, horizontal: 10),
                padding: EdgeInsets.all(10),
                decoration: BoxDecoration(
                  color: Colors.grey[200],
                  border: Border.all(color: Colors.grey),
                  borderRadius: BorderRadius.circular(8),
                ),
                child: Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    Text(
                      battle.name!,
                      style: TextStyle(fontWeight: FontWeight.bold, fontSize: 16),
                    ),
                    SizedBox(height: 5),
                    Text(battle.date!, style: TextStyle(fontSize: 14, fontStyle: FontStyle.italic)),
                  ],
                ),
              ),
            );
          },
        ),
      ),
    );
  }
}
