import 'package:flutter/material.dart';
import 'package:course_app/utils/battle.dart';

class BattleView extends StatelessWidget {
  final List<Battle> battles;

  BattleView(this.battles);  

  @override
  Widget build(BuildContext context) {
    return Expanded(
      child: Padding(
        padding: const EdgeInsets.symmetric(vertical: 8.0),
        child: ListView.builder(
          itemCount: battles.length,
          itemBuilder: (context, index) {
            final battle = battles[index];
            // wrap the container with InkWell for click handling
            return InkWell(
              onTap: () {
                // Handle the tap event here
                // Navigate the page situated at '/battle'
                Navigator.pushNamed(context, '/battle');
              },
              // this part is the same as before
              // we made the container a chold of InkWell
              child: Container(
                margin: EdgeInsets.symmetric(vertical: 5, horizontal: 10),
                padding: EdgeInsets.all(10),
                decoration: BoxDecoration(
                  color: Colors.grey[200],
                  border: Border.all(color: Colors.grey),
                  borderRadius: BorderRadius.circular(8),
                ),
                child: Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    Text(
                      battle.name!,
                      style: TextStyle(fontWeight: FontWeight.bold, fontSize: 16),
                    ),
                    SizedBox(height: 5),
                    Text(battle.date!, style: TextStyle(fontSize: 14, fontStyle: FontStyle.italic)),
                  ],
                ),
              ),
            );
          },
        ),
      ),
    );
  }
}
