import 'dart:convert';
import 'package:http/http.dart' as http;
import 'battle.dart';

class DatabaseHelper {
  static final DatabaseHelper instance = DatabaseHelper._privateConstructor();
  DatabaseHelper._privateConstructor();

  final String baseUrl = "http://192.168.1.8/apps/course_app"; // Update with your server URL

  Future<List<Battle>> getAllBattles() async {
  print(Uri.parse('$baseUrl/fetch_battles.php'));
  final response = await http.get(Uri.parse('$baseUrl/fetch_battles.php'));
  print(response);

  if (response.statusCode == 200) {
    // Decode the JSON response
    final Map<String, dynamic> decoded = json.decode(response.body);

    // Extract the 'data' list from the decoded JSON map
    List<dynamic> data = decoded["data"];

    // Map each item in 'data' to a Battle object
    return data.map((json) => Battle.fromMap(json)).toList();
  } else {
    throw Exception("Failed to load battles");
  }
}

  Future<int> updateBattle(Battle battle) async {
  try {
    final response = await http.post(
      Uri.parse('$baseUrl/update_battle.php'),
      body: battle.toMap(),
    );

    print("Response status: ${response.statusCode}");
    print("Response body: ${response.body}");

    if (response.statusCode == 200) {
      final Map<String, dynamic> data = json.decode(response.body);
      if (data['status'] == 'success') {
        return 1; // Success
      } else {
        throw Exception("Failed to update battle: ${data['message']}");
      }
    } else {
      throw Exception("Failed to update battle with status code: ${response.statusCode}");
    }
  } catch (e) {
    print("Error occurred: $e");
    throw Exception("Failed to update battle: $e");
  }
}

  Future<int> insertBattle(Battle battle) async {
    final response = await http.post(
      Uri.parse('$baseUrl/add_battle.php'),
      body: battle.toMap(),
    );

    if (response.statusCode == 200) {
      return 1; // Success
    } else {
      throw Exception("Failed to insert battle");
    }
  }

  Future<int> deleteBattle(int id) async {
    final response = await http.post(
      Uri.parse('$baseUrl/delete_battle.php'),
      body: {'id': id.toString()},
    );

    if (response.statusCode == 200) {
      return 1; // Success
    } else {
      throw Exception("Failed to delete battle");
    }
  }
}