import 'package:course_app/utils/battle.dart';
import 'package:flutter/material.dart';

class BattleScreen extends StatelessWidget
{  
  Widget build(BuildContext context)
  {
    // We capture the arguments in the variable args
    final args = ModalRoute.of(context)!.settings.arguments as Map<String, dynamic>?;
    // We then get our data, in this case, a Battle object
    // If we received name and date, we will catch
    // everyone in a different variable
    Battle battle = args?['battle'];
    return Scaffold(
      appBar: AppBar(
          title: Text(battle.name),
          backgroundColor: Colors.red,
          centerTitle: true,
        ),
        body: Column(
          crossAxisAlignment: CrossAxisAlignment.start,
          children: [
            Padding(
              padding: const EdgeInsets.all(8.0),
              child: Row(          
                children: 
                [
                  Text('${battle.name}, ',
                    style: TextStyle(fontSize: 32, fontWeight: FontWeight.bold),
                  ),
                  Text('${battle.date}',
                    style: TextStyle(fontSize: 32, fontWeight: FontWeight.bold, fontStyle: FontStyle.italic),
                  ),
                ],
              ),
            ),
            Divider(indent: 5, endIndent: 5, thickness: 1, color: Colors.grey[500],),
            Container(
              padding: EdgeInsets.all(8.0),              
              child: Text('${battle.summary}',
              style: TextStyle(fontSize: 20)),
            ),
        ],)
        
    );
  }
}