import 'package:flutter/material.dart';
import 'package:course_app/widgets/battle_view.dart';
import 'package:course_app/utils/battle_data.dart';

class Home extends StatefulWidget {
  @override
  State<Home> createState() => _HomeState();
}

class _HomeState extends State<Home> {
  int likes = 0;  

  Widget build(BuildContext context) {
    return Scaffold(
        appBar: AppBar(
          title: Text('My Portfolio'),
          backgroundColor: Colors.red,
          centerTitle: true,
        ),
        body: Column(
          children: [
            SizedBox(height: 20),
            Container(
              decoration: BoxDecoration(
                  border: Border.all(color: Colors.black),
                  color: Colors.grey[100]),
              padding: EdgeInsets.all(10),
              margin: EdgeInsets.only(left: 10, right: 10),
              child: Row(
                mainAxisAlignment: MainAxisAlignment.spaceEvenly,
                children: [
                  Image.asset(
                    'lib/assets/images/salah.jpeg',
                    width: 100,
                  ),
                  Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      Text('Name'),
                      Text(
                        'Salaheddine Al-Ayyoubi',
                        style: TextStyle(fontWeight: FontWeight.bold),
                      ),
                    ],
                  ),
                  Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      Text('DoB'),
                      Text(
                        '1138',
                        style: TextStyle(fontWeight: FontWeight.bold),
                      ),
                    ],
                  ),
                ],
              ),
            ),
            SizedBox(height: 20),
            Container(
              padding: EdgeInsets.only(left: 10, right: 10),
              child: Row(
                mainAxisAlignment: MainAxisAlignment.spaceBetween,
                children: [
                  Text('Likes: $likes'),
                  IconButton(
                    iconSize: 30,
                    icon: const Icon(Icons.favorite),
                    color: Colors.red,
                    onPressed: () {
                      setState(() {
                        likes++;
                      });
                    },
                  )
                ],
              ),
            ),
            // this is the widget responsible for showing the 
            // portfolio items
            BattleView(battles),
          ],
        ));
  }
}